/* BControls 

  Macros for creating buttons, menus, etc

  */
#include "wx/listbox.h"
#include "wx/treectrl.h"
#include "wx/stattext.h"

//typedef unsigned __int64 RECORD_ID;
#define ID_INVAL (RECORD_ID)-1;
enum {
	ID_HOME=wxID_HIGHEST,
		ID_TOOLS,
		ID_SETTINGS,
		ID_REPORTS,
		ID_LOGOUT,
		ID_CLOSEPAGE,
		ID_M_QUITBOLT,
		ID_M_CLOSEPAGE,
		ID_M_LOGOUT,
		ID_ABOUT,
		ID_HELP,
		ID_BOLT_NOTEBOOK,
		BOLT_PAGES
};

#define MAX_PAGES 256

//Resources
#define COLOR_HOME		"LIGHT GREY"
#define COLOR_REPORT	"THISTLE"

//Windows


#define BUTTONDEFAULTS wxDefaultPosition,wxDefaultSize,wxBU_AUTODRAW,wxDefaultValidator
#define BMP(x)			wxBitmap(x,wxBITMAP_TYPE_BMP_RESOURCE)

#define BITMAP_DB		BMP("buttonDatabase")
#define BITMASK_DB		BMP("buttonDatabaseMask")

//Login
#define TEXT_LOGIN		"Login"
#define HELP_LOGIN		"Connect to a database"
#define BITMAP_LOGIN	BMP("buttonLogin")
#define	BITMASK_LOGIN	BMP("buttonLoginMask")
#define BUTTON_LOGIN	new wxBitmapButton(this,ID_HOME,BITMAP_LOGIN,BUTTONDEFAULTS,TEXT_HOME)
#define MENU_LOGIN(m)	wxMenuItem(m,ID_HOME,TEXT_HOME,HELP_HOME,FALSE,NULL)

//Home
#define TEXT_HOME		"Home"
#define HELP_HOME		"Go to the start page"
#define BITMAP_HOME		BMP("buttonHome")
#define	BITMASK_HOME	BMP("buttonHomeMask")
#define BUTTON_HOME		new wxBitmapButton(this,ID_HOME,BITMAP_HOME,BUTTONDEFAULTS,TEXT_HOME)
#define MENU_HOME(m)	wxMenuItem(m,ID_HOME,TEXT_HOME,HELP_HOME,FALSE,NULL)

#define TEXT_REPORTS	"Reports"
#define HELP_REPORTS	"Generate reports"
#define BITMAP_REPORTS	BMP("buttonReport")
#define BITMASK_REPORTS BMP("buttonReportMask")
#define BUTTON_REPORTS	new wxBitmapButton(this,ID_REPORTS,BITMAP_REPORTS,BUTTONDEFAULTS,TEXT_REPORTS)
#define MENU_REPORTS(m)	wxMenuItem(m,ID_REPORTS,TEXT_REPORTS,HELP_REPORTS,FALSE,NULL)
//Report Builder
//Report Runner
//Task List
//Tools
#define TEXT_TOOLS	"Tools"
#define HELP_TOOLS	"Open Tools"
#define BITMAP_TOOLS	BMP("buttonTools")
#define BITMASK_TOOLS BMP("buttonToolsMask")
#define BUTTON_TOOLS	new wxBitmapButton(this,ID_TOOLS,BITMAP_TOOLS,BUTTONDEFAULTS,TEXT_TOOLS)
#define MENU_TOOLS(m)	wxMenuItem(m,ID_TOOLS,TEXT_TOOLS,HELP_TOOLS,FALSE,NULL)

//User Settings
//System Settings
//User Manager
//User
//Transaction Settings
//Account Settings
//Codes
//Item Settings
//Tasks Settings
//Printers
//Backup Manager
//Backup Now
//Backup Scheduler
//Recover Backup
#define TEXT_LOGOUT		"Logout"
#define HELP_LOGOUT		"Change user"
#define BITMAP_LOGOUT	BMP("buttonLogout")
#define BITMASK_LOGOUT	BMP("buttonLogoutMask")
#define BUTTON_LOGOUT	new wxBitmapButton(this,ID_LOGOUT,BITMAP_LOGOUT,BUTTONDEFAULTS,TEXT_LOGOUT)
#define MENU_LOGOUT(m)	wxMenuItem(m,ID_LOGOUT,TEXT_LOGOUT,HELP_LOGOUT,FALSE,NULL)

#define TEXT_CLOSEPAGE		"Done"
#define HELP_CLOSEPAGE		"Done with current page"
#define TEXT_ABOUT			"About BITE"
#define TEXT_HELP			"Help"

#define HELP_ABOUT			"About this program"
#define	HELP_HELP			"Help on this program"

#define TEXT_QUITBOLT		"Quit"
#define HELP_QUITBOLT		"Leave BOLT"
#define BITMAP_QUITBOLT		BMP("buttonLogout")
#define BITMASK_QUITBOLT	BMP("buttonLogoutMask")
#define BUTTON_QUITBOLT		new wxBitmapButton(this,ID_QUITBOLT,BITMAP_QUITBOLT,BUTTONDEFAULTS,TEXT_QUITBOLT)
#define MENU_QUITBOLT(m)	wxMenuItem(m,ID_M_QUITBOLT,TEXT_QUITBOLT,HELP_QUITBOLT,FALSE,NULL)

#define ITEM_START 20000
class bcItem : public wxTextCtrl
{
//	DECLARE_DYNAMIC_CLASS(bcItem)
	public:
		bool created;
		void MakeRequired(bool req=TRUE);
		long m_style;
		void SetShort(bool isShort);
		bool showShort;
		bcItem(wxWindow *parent,int id,
			const char *table,const char *field,
			BOLTdb *db,RECORD_ID recID,
			const wxValidator& val=wxDefaultValidator,
			long style=0);
		virtual void OnEdit();
		virtual void OnLeave(wxFocusEvent& event);
		virtual void Refresh();
		wxString table,field,lVal;
virtual void Dump(ostream& stream) 
	{	stream << "Dump : bcItem"; }
	protected:
		wxColour dColour;
		void OnKeyUp(wxKeyEvent &event);
		wxString dbVal;
		virtual void ReadValue();
		virtual void WriteValue(wxString& tVal);
		BOLTdb *db;

		RECORD_ID recID;
		void OnChar(wxKeyEvent& event);
		bool req;
		DECLARE_EVENT_TABLE()
};

class bcPhoneItem : public bcItem
{
//	DECLARE_DYNAMIC_CLASS(bcPhoneItem)
protected:
	virtual void WriteValue(wxString& tVal);
	wxString Seperator;

public:
	bcPhoneItem(wxWindow *parent,int id,
		char *table,char *field,
		BOLTdb *db,RECORD_ID recID,
		const wxValidator& val=wxDefaultValidator,
		long style=0);
virtual void Dump(ostream& stream) 
	{	stream << "Dump : bcPhone"; }

private:
	DECLARE_EVENT_TABLE()
};

class bcDateItem : public bcItem
{
//	DECLARE_DYNAMIC_CLASS(bcDateItem)
protected:
		virtual void ReadValue();
		virtual void WriteValue(wxString& tVal);
	wxString Seperator;

public:
	bcDateItem(wxWindow *parent,int id,
		char *table,char *field,
		BOLTdb *db,RECORD_ID recID,
		const wxValidator& val=wxDefaultValidator,
		long style=0);
virtual void Dump(ostream& stream) 
	{	stream << "Dump : bcDateItem"; }
private:
	DECLARE_EVENT_TABLE()
};

//class bcChoice : public wxRadioBox
class bcChoice : public wxChoice
{
//DECLARE_DYNAMIC_CLASS(bcChoice)
	private:
		BOLTdb *db;
		wxString table,field,lVal;
		RECORD_ID recID;
	public:
		static void OnRadioBox(wxCommandEvent & event);
		bcChoice(wxWindow *parent,int id,const char *label,int n, const wxString choices[],char *table,char *field,BOLTdb *db,RECORD_ID recID,long style=0);
		virtual void Refresh();
		void OnChoice(wxCommandEvent & event);
virtual void Dump(ostream& stream) 
	{	stream << "Dump : bcChoice"; }
	private:
		DECLARE_EVENT_TABLE()
};

class bcChoiceText : public wxChoice
{
//DECLARE_DYNAMIC_CLASS(bcChoice)
	private:
		BOLTdb *db;
		wxString table,field,lVal;
		RECORD_ID recID;
	public:
		static void OnRadioBox(wxCommandEvent & event);
		bcChoiceText(wxWindow *parent,int id,const char *label,int n, const wxString choices[],char *table,char *field,BOLTdb *db,RECORD_ID recID,long style=0);
		virtual void Refresh();
		void OnChoice(wxCommandEvent & event);
virtual void Dump(ostream& stream) 
	{	stream << "Dump : bcChoice"; }
	private:
		DECLARE_EVENT_TABLE()
};

class bcStatic : public wxStaticText
//class bcStatic : public wxTextCtrl
{
	private:
		BOLTdb *db;
		wxString table,field,lVal;
		RECORD_ID recID;
	public:
		bcStatic(wxWindow *parent,int id,const char *label,char *table,const char *field,BOLTdb *db,RECORD_ID recID,long style=wxTE_READONLY|wxTE_RICH|wxTE_MULTILINE);
		virtual void Refresh();
virtual void Dump(ostream& stream) 
	{	stream << "Dump : bcStatic"; }

};

//class bcQuery : public wxStaticText
class bcQuery : public wxTextCtrl
{
	private:
		BOLTdb *db;
		wxString query,lVal;
		RECORD_ID recID;
	public:
		void SetQuery(const char *query);
		bcQuery(wxWindow *parent,int id,const char *
	label,const char *query,BOLTdb *db,long style=wxTE_READONLY|wxTE_RICH|wxTE_MULTILINE);
		virtual void Refresh();
		
virtual void Dump(ostream& stream) 
	{	stream << "Dump : bcQuery"; }

};

class bcQueryList : public wxTreeCtrl
{
//DECLARE_DYNAMIC_CLASS(bcQueryList)
public:
	bool AddQuery(const char *name,const char *query,const char *col,const char *subQuery);
	bool AddQuery(wxString& name,wxString& query,const char *col,wxString& subQuery);
	void DeleteItemData(wxTreeItemId itemId);
	virtual void OnKey(wxKeyEvent &event);
	bcQueryList(BOLTdb *dbase,wxWindow* parent,wxWindowID id,wxString& label, long style = wxTR_HAS_BUTTONS|wxTAB_TRAVERSAL);
	~bcQueryList();
	bool AddQuery(wxString& name,wxString& query,const char *col="WHITE");
	bool AddQuery(const char *name,const char *query,const char *col="WHITE");
	bool ClearQueries();
	RECORD_ID GetChoice();
	virtual void Refresh();
	void OnColapse(wxTreeEvent & event);
	void OnExpand(wxTreeEvent & event);
virtual void Dump(ostream& stream) 
	{	stream << "Dump : bcQueryList"; }

private:
	bool RunQueries();
	BOLTdb *db;
	wxString label;
	wxArrayString queryNames;
	wxArrayString queryText;
	DECLARE_EVENT_TABLE()
protected:
};